var color1= 0xffffff; /*white*/
var color2= 0x020227;  /*kohly*/
var color3= 0x1c5c61; /*teal*/
var color4= "#fa6e70"; //red/orange
var color5="#380152"; //purple
var color6="#696767"; //grey
var setup;
var simulationContainerName="simulation";
var simulationContainerName1="webgl1";
var simulationContainer1=document.getElementById( simulationContainerName1 );
var simulationContainer=document.getElementById( simulationContainerName );



function gui(){
	var gui = new dat.GUI();
	var f1 = gui.addFolder('Displacement Animation');
	f1.add(setup.animation, 'showDisplacement');
	f1.add(setup.animation, 'exageration', 0, 10000);
	f1.add(setup.animation, 'speed', 0, 5);

	var f2 = gui.addFolder('Stresses Visualization');
	f2.add(setup.viz, 'minStress', -1000, 0).listen();
	f2.add(setup.viz, 'maxStress', 0, 1000).listen();
	f2.add(setup.viz, 'colorMap', {coolwarm:0, YlGnBu:1, winter:2,jet:3});

	// gui.add(setup, 'solve');

	for (j in f2.__controllers) f2.__controllers[j].onChange (colorEdges);
	
}

var line, renderer, scene, camera, camera2, controls;
var line1;
var matLineBasic, matLineDashed;
var stats;
// var gui;
// viewport
// var insetWidth;
// var insetHeight;
var counter=0;
var clock = new THREE.Clock();

function init() {
	renderer = new THREE.WebGLRenderer( { antialias: true } );
	renderer.setPixelRatio( window.devicePixelRatio );
	renderer.setClearColor( color1, 1.0 );
	renderer.setSize( getWidth(), getHeight() );
	simulationContainer1.appendChild( renderer.domElement );
	scene = new THREE.Scene();
	camera = new THREE.PerspectiveCamera( 40, getWidth() / getHeight(), 1, 1000 );
	camera.position.set( - 40, 0, 60 );

	controls = new THREE.OrbitControls( camera, renderer.domElement );
	controls.minDistance = 10;
	controls.maxDistance = 500;
	matLineBasic = new THREE.LineMaterial( {
		color: 0xffffff,
		linewidth: 5, // in pixels
		vertexColors: THREE.VertexColors,
		//resolution:  // to be set by renderer, eventually
		dashed: false,
		visible:false
	} );
	// matLineDashed = new THREE.LineMaterial( {
	// 	color: 0xffffff,
	// 	linewidth: 5, // in pixels
	// 	vertexColors: THREE.VertexColors,
	// 	//resolution:  // to be set by renderer, eventually
	// 	dashed: true,
	// 	dashSize : 1.0,
	// 	gapSize : 1.0

	// } );
	
	// matLineDashed.defines.USE_DASH = ""; 
	matLineDashed = new THREE.LineMaterial( {
		color: 0xffffff,
		linewidth: 5, // in pixels
		vertexColors: THREE.VertexColors,
		//resolution:  // to be set by renderer, eventually
		dashed: false
	} );

	
	
	
	
	

	var helper = new THREE.GridHelper( 50, 50 );
    helper.position.y = -5;
    helper.material.opacity = 0.5;
    helper.material.transparent = true;
	// scene.add( helper );
	
	// draw forces
	
	// draw degrees of freedom
	simulationContainer.addEventListener( 'resize', onWindowResize, false );
	onWindowResize();

	// gui();
	
	
}
//////////////////////Threejs utils//////////////////////////////////////

function drawStructure(){
	//draw edges
	for(var i=0;i<setup.edges.length;i++){
		createEdge(setup.nodes[setup.edges[i].source].position,setup.nodes[setup.edges[i].target].position,setup.edges[i].id),false;
		createEdge(setup.nodes[setup.edges[i].source].position,setup.nodes[setup.edges[i].target].position,setup.edges[i].id,true);
	}
	
	// draw nodes
	for(var i=0;i<setup.nodes.length;i++){
		createNode(setup.nodes[i].position,setup.nodes[i].id,false,setup.nodes[i].restrained_degrees_of_freedom[0]);
		createNode(setup.nodes[i].position,setup.nodes[i].id,true,setup.nodes[i].restrained_degrees_of_freedom[0]);
	}

	drawForces();
}

function createEdge(fromPoint,toPoint,name,displacement){

	fromPoint=toThreeVec(fromPoint);
	toPoint=toThreeVec(toPoint);
	var positions = [];
	var colors = [];
	var points =[fromPoint,toPoint];

	var spline = new THREE.CatmullRomCurve3( points );
	var divisions = Math.round( 12 * points.length );

	var color = new THREE.Color();

	for ( var i = 0, l = divisions; i <= l; i ++ ) {
		var point = spline.getPoint( i / l );
		positions.push( point.x, point.y, point.z );
		
		// color.setHSL( i / l, 1.0, 0.5 );
		color=interpolateLinearly(i / l, setup.viz.colorMaps[setup.viz.colorMap]);
		// color=interpolateLinearly(i / l, coolwarm);
		colors.push( color[0], color[1], color[2]);
	}

	var geometry = new THREE.LineGeometry();
	geometry.setPositions( positions );
	geometry.setColors( colors );
	
	
	var line;
	if(displacement){
		line = new THREE.Line2( geometry, matLineDashed );
	}else{
		line = new THREE.Line2( geometry, matLineBasic );
	}
	line.computeLineDistances();
	line.scale.set( 1, 1, 1 );
	
	if(displacement){
		line.name='d'+name;
	}else{
		line.name=name;
	}
	
	scene.add( line );

}

function createNode(point,name,displacement,restrained){
	var geometry = new THREE.BoxGeometry( 1, 1, 1 );
	var material;

	if(restrained){
		material = new THREE.MeshBasicMaterial( {color: color4} );
	}else{
		material = new THREE.MeshBasicMaterial( {color: color3} );
	}

	if(displacement){
		material.transparent=true;
		material.opacity=0.7;
	}else{
		material.transparent=true;
		material.opacity=0.0;

	}
	var cube = new THREE.Mesh( geometry, material );
	cube.position.set(point.x, point.y, point.z);
	cube.scale.set(0.5, 0.5,0.5);
	
	if(displacement){
		cube.name='d'+name;
	}else{
		cube.name=name;
	}
	scene.add( cube );

}

function editEdge(fromPoint,toPoint,name){
	var edge = scene.getObjectByName(name);
	var positions = [];
	var points =[fromPoint,toPoint];

	var spline = new THREE.CatmullRomCurve3( points );
	var divisions = Math.round( 12 * points.length );

	// var color = new THREE.Color();

	for ( var i = 0, l = divisions; i <=l; i ++ ) {
		var point = spline.getPoint( i / l );
		positions.push( point.x, point.y, point.z );
		
	}
	// edge.geometry.setDrawRange( 0, newValue );
	// edge.geometry.setPositions( positions );
	// edge.geometry.attributes.position.needsUpdate = true; 
	edge.geometry.setPositions( positions );
	// geometry.setColors( colors );
	
	
}

function drawForces(){
	for(var i=0;i<setup.nodes.length;i++){
		
		var dx=0.1;
		var o=toThreeVec(setup.nodes[i].position);
		var dir = toThreeVec(setup.nodes[i].force);
		var length = dir.length ();
		dir.normalize();
		var scale=0.002;
		if(length!=0){
			var arrowhelper=new THREE.ArrowHelper( dir, o.sub(dir), scale*length, color4 ,scale*length, scale*length);
			// var arrowhelper=new THREE.ArrowHelper( dir, o.sub(dir), scale*length, color5);
			scene.add(arrowhelper);
		}
	}
}

///////
function animate() {
	requestAnimationFrame( animate );
	// main scene
	onWindowResize() ;

	renderer.setClearColor( color1, 1 );
	renderer.setViewport( 0, 0, getWidth(), getHeight() );
	
	// renderer will set this eventually
	matLineBasic.resolution.set(  getWidth(), getHeight() ); // resolution of the viewport
	matLineDashed.resolution.set( getWidth(),getHeight() ); // resolution of the viewport
	renderer.render( scene, camera );

	var timeElapsed = clock.getElapsedTime();
	var speed=setup.animation.speed;
	var exageration=setup.animation.exageration;
	// var exageration=0.01;
	
	if(setup.animation.showDisplacement){
		//displacement animation edges
		for(var i=0;i<setup.edges.length;i++){
			var fromPoint=new THREE.Vector3(0,0,0);
			var toPoint=new THREE.Vector3(0,0,0);
			var node1=setup.nodes[setup.edges[i].source];
			var node2=setup.nodes[setup.edges[i].target];
			fromPoint.x = node1.position.x+node1.displacement.x*exageration+ Math.sin(timeElapsed*speed)* node1.displacement.x*exageration ;
			fromPoint.y = node1.position.y+node1.displacement.y*exageration+ Math.sin(timeElapsed*speed)* node1.displacement.y*exageration ;
			fromPoint.z = node1.position.z+node1.displacement.z*exageration+ Math.sin(timeElapsed*speed)* node1.displacement.z*exageration ;
			toPoint.x   = node2.position.x+node2.displacement.x*exageration+ Math.sin(timeElapsed*speed)* node2.displacement.x*exageration ;
			toPoint.y   = node2.position.y+node2.displacement.y*exageration+ Math.sin(timeElapsed*speed)* node2.displacement.y*exageration ;
			toPoint.z   = node2.position.z+node2.displacement.z*exageration+ Math.sin(timeElapsed*speed)* node2.displacement.z*exageration ;

			editEdge(fromPoint,toPoint,'d'+setup.edges[i].id);
			
		}
		//displacement animation nodes
		for(var i=0;i<setup.nodes.length;i++){
			var node = scene.getObjectByName('d'+setup.nodes[i].id);
			// var origPos=toThreeVec(setup.nodes[i].position);
			// var displacement=toThreeVec(setup.nodes[i].displacement).multiplyScalar(exageration);
			// var currPos=origPos.clone().addVectors(displacement,displacement.clone().multiplyScalar(Math.sin(timeElapsed*speed)));
			// nodeD.position.set(currPos.x,currPos.y,currPos.z);
			node.position.x = setup.nodes[i].position.x+setup.nodes[i].displacement.x*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].displacement.x*exageration ;
			node.position.y = setup.nodes[i].position.y+setup.nodes[i].displacement.y*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].displacement.y*exageration ;
			node.position.z = setup.nodes[i].position.z+setup.nodes[i].displacement.z*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].displacement.z*exageration ;

			node.rotation.x = 0+setup.nodes[i].angle.x*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].angle.x*exageration ;
			node.rotation.y = 0+setup.nodes[i].angle.y*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].angle.y*exageration ;
			node.rotation.z = 0+setup.nodes[i].angle.z*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].angle.z*exageration ;
		
		}

	}
	
}

function animateEuler() {
	requestAnimationFrame( animateEuler );
	// main scene
	renderer.setClearColor( color2, 1 );
	renderer.setViewport( 0, 0, getWidth(), getHeight() );
	// renderer will set this eventually
	matLineBasic.resolution.set(  getWidth(), getHeight() ); // resolution of the viewport
	matLineDashed.resolution.set( getWidth(), getHeight() ); // resolution of the viewport
	renderer.render( scene, camera );

	var timeElapsed = clock.getElapsedTime();
	var speed=setup.animation.speed;
	var exageration=setup.animation.exageration;
	// var exageration=0.01;

	doTimeStep(setup,dt);

	if(setup.animation.showDisplacement){
		//displacement animation edges
		// for(var i=0;i<setup.edges.length;i++){
		// 	var fromPoint=new THREE.Vector3(0,0,0);
		// 	var toPoint=new THREE.Vector3(0,0,0);
		// 	var node1=setup.nodes[setup.edges[i].source];
		// 	var node2=setup.nodes[setup.edges[i].target];
		// 	fromPoint.x = node1.position.x+node1.displacement.x*exageration+ Math.sin(timeElapsed*speed)* node1.displacement.x*exageration ;
		// 	fromPoint.y = node1.position.y+node1.displacement.y*exageration+ Math.sin(timeElapsed*speed)* node1.displacement.y*exageration ;
		// 	fromPoint.z = node1.position.z+node1.displacement.z*exageration+ Math.sin(timeElapsed*speed)* node1.displacement.z*exageration ;
		// 	toPoint.x   = node2.position.x+node2.displacement.x*exageration+ Math.sin(timeElapsed*speed)* node2.displacement.x*exageration ;
		// 	toPoint.y   = node2.position.y+node2.displacement.y*exageration+ Math.sin(timeElapsed*speed)* node2.displacement.y*exageration ;
		// 	toPoint.z   = node2.position.z+node2.displacement.z*exageration+ Math.sin(timeElapsed*speed)* node2.displacement.z*exageration ;

		// 	editEdge(fromPoint,toPoint,'d'+setup.edges[i].id);
			
		// }
		//displacement animation nodes
		for(var i=0;i<setup.nodes.length;i++){
			var node = scene.getObjectByName('d'+setup.nodes[i].id);
			// var origPos=toThreeVec(setup.nodes[i].position);
			// var displacement=toThreeVec(setup.nodes[i].displacement).multiplyScalar(exageration);
			// var currPos=origPos.clone().addVectors(displacement,displacement.clone().multiplyScalar(Math.sin(timeElapsed*speed)));
			// nodeD.position.set(currPos.x,currPos.y,currPos.z);
			node.position.x = setup.nodes[i].currPosition.x;
			node.position.y = setup.nodes[i].currPosition.y;
			node.position.z = setup.nodes[i].currPosition.z;

			// node.rotation.x = 0+setup.nodes[i].angle.x*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].angle.x*exageration ;
			// node.rotation.y = 0+setup.nodes[i].angle.y*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].angle.y*exageration ;
			// node.rotation.z = 0+setup.nodes[i].angle.z*exageration+ Math.sin(timeElapsed*speed)* setup.nodes[i].angle.z*exageration ;
		
		}

	}
	
}

function onWindowResize() {
	camera.aspect = getWidth() / getHeight();
	camera.updateProjectionMatrix();
	renderer.setSize( getWidth(), getHeight() );
}

var getWidth=function(){
    // return container.style.width;
    return $('#'+simulationContainerName).width() ;
};

var getHeight=function(){
    // return container.style.height;
    return $('#'+simulationContainerName).height() ;
};









