let _rhino3dm = null;
// // wait for the rhino3dm web assembly to load asynchronously
rhino3dm().then(function(m) {// todo change call to app.js
	_rhino3dm = m; // global
	// initRhino3dm(1,10,createVoxelnotRhino,true,true);
	console.log("Loaded RhinoScript");
	//saveJSON();
});

// initialize 
function initRhino3dm(latticeSize,voxelSize,voxelBuilder,addForces,solve) {//later change type to dictiary
	console.log("Loaded RhinoScript");
    
    // var voxelSize=10.0;
    // var latticeSize=5;

    createLattice(voxelSize,latticeSize,latticeSize,latticeSize,voxelBuilder);

	restrainBelow(-voxelSize/2);
	if(addForces){ //don't add forces chiral //todo fix
		addForceAbove(0.75*voxelSize*latticeSize,{x:0,y:-400,z:0});
	}
    
    if(solve){
        solveFea();
	}
	
}

////////////////////////////////////////////////////////////
function createLattice(size,sizeX,sizeY,sizeZ,voxelBuilder){

    for(var i=0;i<sizeX;i++){
        for(var j=0;j<sizeY;j++){
            for(var k=0;k<sizeZ;k++){
                voxelBuilder(size,new THREE.Vector3(i*size,j*size,k*size));
            }
        }
    }
    

}
function simulate(size,timeline,voxelBuilder ){
	init();
	console.log(timeline.length)
	for(var i=0;i<timeline.length;i++){ //TODO LATER CHANGE TO OCCUPANCY
		console.log(timeline[i]);
		voxelBuilder(size,new THREE.Vector3(timeline[i].x*size,timeline[i].y*size,timeline[i].z*size));
	}
	drawStructure();
	colorEdges();
	animate();
}

function createVoxel(size,position){
    

    var sphere = new _rhino3dm.Sphere([0,0,0], size/2);
    var box = sphere.toBrep().getBoundingBox();
    // console.log(box.min)
    box = box.toBrep();
    
    for(var i=0; i<6;i++){//for each face

        // var restrained=false;
        // var force=new THREE.Vector3(0,0,0);
        // if(i==0){
        //     restrained=true;
        // }
        // if(i==2){
        //     force=new THREE.Vector3(0,-200,0);
        //     // restrained=true;
        // }
        nodesIndices=[];
        var face=box.faces().get(i);
        
        
		nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(size  , size/2)))));
        nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(size/2, 0     )))));
        nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(0     , size/2)))));
        nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(size/2, size  )))));
        
        linkNodes(nodesIndices);
		
	}
}

function createChiralVoxel(size,position){
    

    var sphere = new _rhino3dm.Sphere([0,0,0], size/2);
    var box = sphere.toBrep().getBoundingBox();
    // console.log(box.min)
    box = box.toBrep();
    
    for(var i=0; i<6;i++){//for each face

        var nodesIndices=[];
        var face=box.faces().get(i);
        
        
		nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(size  , size/2)))));
        nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(size/2, 0     )))));
        nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(0     , size/2)))));
        nodesIndices.push(checkandAdd(add(position,toPosition(face.pointAt(size/2, size  )))));
        
        // linkNodes(nodesIndices);

        var n=8;
        var c= new _rhino3dm.Circle(size/3.5);
		c=c.toNurbsCurve();
		var rot=[1,0,0];
        
        var nodesIndices1=[];
		
		c.domain=[0,1];
		// console.log(rot);
		// console.log(c.tangentAt(i*1/4+1/4));
		rot=c.tangentAt(i*1/4+1/4);
		if(i>3){
			rot=face.normalAt(0, 0);
		}
		c.rotate(Math.PI/2,rot , [0,0,0]);
		c.translate(face.pointAt(size/2, size/2));
		for(var ii=0; ii<n;ii++){//for each face
            // createNode(toPosition(c.pointAt(ii*1/n)),'e',false,[]);
            nodesIndices1.push(checkandAdd(add(position,toPosition(c.pointAt(ii*1/n)))));
        }
        linkNodes(nodesIndices1);

        if(i==0){
            addEdge(nodesIndices[0], nodesIndices1[1], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[1], nodesIndices1[3], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[2], nodesIndices1[5], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[3], nodesIndices1[7], 1.0, 0.284 , 30.0e6);

        }else if(i==1){
            addEdge(nodesIndices[3], nodesIndices1[1], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[0], nodesIndices1[3], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[1], nodesIndices1[5], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[2], nodesIndices1[7], 1.0, 0.284 , 30.0e6);

        }else if(i==2){
            addEdge(nodesIndices[0], nodesIndices1[5], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[1], nodesIndices1[7], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[2], nodesIndices1[1], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[3], nodesIndices1[3], 1.0, 0.284 , 30.0e6);

            var force=new THREE.Vector3(0,-400,0);
            addForce('n'+nodesIndices[0],force);
            addForce('n'+nodesIndices[1],force);
            addForce('n'+nodesIndices[2],force);
            addForce('n'+nodesIndices[3],force);

        }else if(i==3){

            addEdge(nodesIndices[3], nodesIndices1[5], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[0], nodesIndices1[7], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[1], nodesIndices1[1], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[2], nodesIndices1[3], 1.0, 0.284 , 30.0e6);
        }else if(i==4){
            addEdge(nodesIndices[0], nodesIndices1[5], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[1], nodesIndices1[7], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[2], nodesIndices1[1], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[3], nodesIndices1[3], 1.0, 0.284 , 30.0e6);
        }else if(i==5){
            addEdge(nodesIndices[0], nodesIndices1[5], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[1], nodesIndices1[3], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[2], nodesIndices1[1], 1.0, 0.284 , 30.0e6);
            addEdge(nodesIndices[3], nodesIndices1[7], 1.0, 0.284 , 30.0e6);
        }
	}
}

/////////////////
function createOldVoxelnotRhino(size,position){
	addNode(position.clone().add(new THREE.Vector3(0,0,0)),true, new THREE.Vector3(0,0,0));

	addNode(position.clone().add(new THREE.Vector3(-size, size*1.5,-size)),false, new THREE.Vector3(0,-200,0));
	addNode(position.clone().add(new THREE.Vector3(-size, size*1.5, size)),false, new THREE.Vector3(0,-200,0));
	addNode(position.clone().add(new THREE.Vector3( size, size*1.5, size)),false, new THREE.Vector3(0,-200,0));
	addNode(position.clone().add(new THREE.Vector3( size, size*1.5,-size)),false, new THREE.Vector3(0,-200,0));

	addNode(position.clone().add(new THREE.Vector3(0, size*1.5*2,0)),false, new THREE.Vector3(0,-400,0));

	addEdge(0, 1, 1.0, 0.284 , 30.0e6);
	addEdge(0, 2, 1.0, 0.284 , 30.0e6);
	addEdge(0, 3, 1.0, 0.284 , 30.0e6);
	addEdge(0, 4, 1.0, 0.284 , 30.0e6);
  
	addEdge(1, 2, 1.0, 0.284 , 30.0e6);
	addEdge(2, 3, 1.0, 0.284 , 30.0e6);
	addEdge(3, 4, 1.0, 0.284 , 30.0e6);
	addEdge(4, 1, 1.0, 0.284 , 30.0e6);
  
	addEdge(5, 1, 1.0, 0.284 , 30.0e6);
	addEdge(5, 2, 1.0, 0.284 , 30.0e6);
	addEdge(5, 3, 1.0, 0.284 , 30.0e6);
	addEdge(5, 4, 1.0, 0.284 , 30.0e6);
	
	
	
	// console.log(setup)
}

function createVoxelnotRhino(size,position){
	//down square
	addNode(position.clone().add(new THREE.Vector3(-size, 0,-size)),true, new THREE.Vector3(0,0,0));//0
	addNode(position.clone().add(new THREE.Vector3(-size, 0,    0)),true, new THREE.Vector3(0,0,0));//1//mid
	addNode(position.clone().add(new THREE.Vector3(-size, 0, size)),true, new THREE.Vector3(0,0,0));//2
	addNode(position.clone().add(new THREE.Vector3(    0, 0, size)),true, new THREE.Vector3(0,0,0));//3//mid
	addNode(position.clone().add(new THREE.Vector3( size, 0, size)),true, new THREE.Vector3(0,0,0));//4
	addNode(position.clone().add(new THREE.Vector3( size, 0,    0)),true, new THREE.Vector3(0,0,0));//5//mid
	addNode(position.clone().add(new THREE.Vector3( size, 0,-size)),true, new THREE.Vector3(0,0,0));//6
	addNode(position.clone().add(new THREE.Vector3(    0, 0,-size)),true, new THREE.Vector3(0,0,0));//7//mid
	
	addEdge(0, 1, 1.0, 0.284 , 30.0e6);
	addEdge(1, 2, 1.0, 0.284 , 30.0e6);
	addEdge(2, 3, 1.0, 0.284 , 30.0e6);
	addEdge(3, 4, 1.0, 0.284 , 30.0e6);
	addEdge(4, 5, 1.0, 0.284 , 30.0e6);
	addEdge(5, 6, 1.0, 0.284 , 30.0e6);
	addEdge(6, 7, 1.0, 0.284 , 30.0e6);
	addEdge(7, 0, 1.0, 0.284 , 30.0e6);

	addEdge(1, 3, 1.0, 0.284 , 30.0e6);
	addEdge(3, 5, 1.0, 0.284 , 30.0e6);
	addEdge(5, 7, 1.0, 0.284 , 30.0e6);
	addEdge(7, 1, 1.0, 0.284 , 30.0e6);

	//up square
	addNode(position.clone().add(new THREE.Vector3(-size, size*2,-size)),false, new THREE.Vector3(0,-400,0));//0+8
	addNode(position.clone().add(new THREE.Vector3(-size, size*2,    0)),false, new THREE.Vector3(0,-400,0));//1+8//mid
	addNode(position.clone().add(new THREE.Vector3(-size, size*2, size)),false, new THREE.Vector3(0,-400,0));//2+8
	addNode(position.clone().add(new THREE.Vector3(    0, size*2, size)),false, new THREE.Vector3(0,-400,0));//3+8//mid
	addNode(position.clone().add(new THREE.Vector3( size, size*2, size)),false, new THREE.Vector3(0,-400,0));//4+8
	addNode(position.clone().add(new THREE.Vector3( size, size*2,    0)),false, new THREE.Vector3(0,-400,0));//5+8//mid
	addNode(position.clone().add(new THREE.Vector3( size, size*2,-size)),false, new THREE.Vector3(0,-400,0));//6+8
	addNode(position.clone().add(new THREE.Vector3(    0, size*2,-size)),false, new THREE.Vector3(0,-400,0));//7+8//mid
	
	addEdge(0+8, 1+8, 1.0, 0.284 , 30.0e6);
	addEdge(1+8, 2+8, 1.0, 0.284 , 30.0e6);
	addEdge(2+8, 3+8, 1.0, 0.284 , 30.0e6);
	addEdge(3+8, 4+8, 1.0, 0.284 , 30.0e6);
	addEdge(4+8, 5+8, 1.0, 0.284 , 30.0e6);
	addEdge(5+8, 6+8, 1.0, 0.284 , 30.0e6);
	addEdge(6+8, 7+8, 1.0, 0.284 , 30.0e6);
	addEdge(7+8, 0+8, 1.0, 0.284 , 30.0e6);

	addEdge(1+8, 3+8, 1.0, 0.284 , 30.0e6);
	addEdge(3+8, 5+8, 1.0, 0.284 , 30.0e6);
	addEdge(5+8, 7+8, 1.0, 0.284 , 30.0e6);
	addEdge(7+8, 1+8, 1.0, 0.284 , 30.0e6);
	
	//left square

	addNode(position.clone().add(new THREE.Vector3(-size, size,-size)),false, new THREE.Vector3(0,0,0));//0+16
	addNode(position.clone().add(new THREE.Vector3( size, size,-size)),false, new THREE.Vector3(0,0,0));//1+16
	
	addEdge(0, 16, 1.0, 0.284 , 30.0e6);
	addEdge(16, 8, 1.0, 0.284 , 30.0e6);

	addEdge(6, 17, 1.0, 0.284 , 30.0e6);
	addEdge(17, 14, 1.0, 0.284 , 30.0e6);

	addEdge(16, 07, 1.0, 0.284 , 30.0e6);
	addEdge(15, 16, 1.0, 0.284 , 30.0e6);
	addEdge(17, 15, 1.0, 0.284 , 30.0e6);
	addEdge(07, 17, 1.0, 0.284 , 30.0e6);

	//right square
	addNode(position.clone().add(new THREE.Vector3(-size, size, size)),false, new THREE.Vector3(0,0,0));//0+18
	addNode(position.clone().add(new THREE.Vector3( size, size, size)),false, new THREE.Vector3(0,0,0));//1+18

	addEdge(2, 18, 1.0, 0.284 , 30.0e6);
	addEdge(18, 10, 1.0, 0.284 , 30.0e6);

	addEdge(4, 19, 1.0, 0.284 , 30.0e6);
	addEdge(19, 12, 1.0, 0.284 , 30.0e6);

	addEdge(18, 03, 1.0, 0.284 , 30.0e6);
	addEdge(11, 18, 1.0, 0.284 , 30.0e6);
	addEdge(19, 11, 1.0, 0.284 , 30.0e6);
	addEdge(03, 19, 1.0, 0.284 , 30.0e6);

	//front square
	addEdge(16, 01, 1.0, 0.284 , 30.0e6);
	addEdge(09, 16, 1.0, 0.284 , 30.0e6);
	addEdge(18, 09, 1.0, 0.284 , 30.0e6);
	addEdge(01, 18, 1.0, 0.284 , 30.0e6);


	//back square
	addEdge(17, 05, 1.0, 0.284 , 30.0e6);
	addEdge(13, 17, 1.0, 0.284 , 30.0e6);
	addEdge(19, 13, 1.0, 0.284 , 30.0e6);
	addEdge(05, 19, 1.0, 0.284 , 30.0e6);
	
}

function createSimpleSetupnotRhino(size,position){
	addNode(position.clone().add(new THREE.Vector3(-0, 2*size,-0)),true, new THREE.Vector3(0,0,0));//0
	addNode(position.clone().add(new THREE.Vector3(-0,      0,-0)),true, new THREE.Vector3(0,0,0));//0
	addNode(position.clone().add(new THREE.Vector3(2*size, size,)),false, new THREE.Vector3(0,-200,0));//0

	addEdge(0, 2, 1.0, 0.284 , 30.0e6);
	addEdge(1, 2, 2.0, 0.284 , 30.0e6);
	
}

///old setups
var setupSimple={
	nodes: [
	{
		id: 'n0', 
		parent: '11',
		degrees_of_freedom:[0,1,2,3,4,5] ,
		restrained_degrees_of_freedom:[true,true,true,true,true,true],
		position: { x: 0, y: 10,z:0 },
		force:{ x: 0, y: 0,z:0 },
		displacement: { x: 0, y: -0,z:0 },
		angle: { x: 0, y: 0,z:0 }
	},
	{
		id: 'n1', 
		parent: '11',
		degrees_of_freedom:[6,7,8,9,10,11]  ,
		restrained_degrees_of_freedom:[true,true,true,true,true,true],
		position: { x: 0, y: 0,z:0  },
		force:{ x: 0, y: 0 },
		displacement: { x: 0, y: 0,z:0 },
		angle: { x: 0, y: 0,z:0 }
	},
	{
		id: 'n2',
		parent: '11',
		degrees_of_freedom:[12,13,14,15,16,17,18]  ,
		restrained_degrees_of_freedom:[false,false,false,false,false,false],
		position: { x: 10, y: 5,z:0  },
		force:{ x: 0, y: -200,z:0 },
		displacement: { x: 0, y: 0,z:0 },
		angle: { x: 0, y: 0,z:0 }
	}
		],
	edges: [
		{ id: 'e0', source: 0, target: 2 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e1', source: 1, target: 2 ,area:2.0,density:0.284,stiffness:30.0e6,stress:0}
	],

	//material properties - AISI 1095 Carbon Steel (Spring Steel)
	ndofs   : 3*6,

	animation :  {
	
		showDisplacement : true,
		exageration : 10000,
		speed:3.0
		
	},
	viz :  {
	
		
		minStress:-500,
		maxStress: 500,
		colorMaps:[YlGnBu, winter, coolwarm,jet],
		colorMap:0,
		
	},
	solve: solveFea,
	bar:false
	
};

var oldVoxel={
	nodes: [
	{
	  id: 'n0', 
	  parent: '11',
	  degrees_of_freedom:[0,1,2] , //todo automate
	  restrained_degrees_of_freedom:[true,true,true],
	  position: { x: 0, y: 0,z:0 },
	  force:{ x: 0, y: 0,z:0 },
	  displacement: { x: 0, y: 0,z:0 }
	},
	{
		id: 'n1', 
		parent: '11',
		degrees_of_freedom:[3,4,5]  ,
		restrained_degrees_of_freedom:[false,false,false],
		position: { x: -5, y: 7.5,z:-5  },
		force:{ x: 0, y: -200,z:0 },
		displacement: { x: 0, y: 0,z:0 }
	},
	{
		id: 'n2',
		parent: '11',
		degrees_of_freedom:[6,7,8]  ,
		restrained_degrees_of_freedom:[false,false,false],
		position: { x: -5, y: 7.5,z:5  },
		force:{ x: 0, y: -200,z:0 },
		displacement: { x: 0, y: 0,z:0 }
	},
	{
		id: 'n3',
		parent: '11',
		degrees_of_freedom:[9,10,11]  ,
		restrained_degrees_of_freedom:[false,false,false],
		position: { x: 5, y: 7.5,z:5  },
		force:{ x: 0, y:-200,z:0 },
		displacement: { x: 0, y: 0,z:0 }
	},
	{
		id: 'n4',
		parent: '11',
		degrees_of_freedom:[12,13,14]  ,
		restrained_degrees_of_freedom:[false,false,false],
		position: { x: 5, y: 7.5,z: -5  },
		force:{ x: 0, y: -200,z:0 },
		displacement: { x: 0, y: 0,z:0 }
	},
	{
		id: 'n5',
		parent: '11',
		degrees_of_freedom:[15,16,17]  ,
		restrained_degrees_of_freedom:[false,false,false],
		position: { x: 0, y: 15,z: 0  },
		force:{ x: 0, y: -400,z:0 },
		displacement: { x: 0, y: 0,z:0 }
	}
  	],
	edges: [
		{ id: 'e0', source: 0, target: 1 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e1', source: 0, target: 2 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e2', source: 0, target: 3 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e3', source: 0, target: 4 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },

		{ id: 'e4', source: 1, target: 2 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e5', source: 2, target: 3 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e6', source: 3, target: 4 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e7', source: 4, target: 1 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },

		{ id: 'e8', source: 5, target: 1 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e9', source: 5, target: 2 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e10', source: 5, target: 3 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },
		{ id: 'e11', source: 5, target: 4 ,area:1.0,density:0.284,stiffness:30.0e6,stress:0 },

	],
	//material properties - AISI 1095 Carbon Steel (Spring Steel)
	ndofs   : 6*3,

	animation :  {
	
		showDisplacement : true,
		exageration : 10000,
		speed:3.0
		
	},
	viz :  {
	
		
		minStress:-500,
		maxStress: 500,
		colorMaps:[YlGnBu, winter, coolwarm,jet],
		colorMap:0,
		
	},
	solve: solveFea,
	bar:true
	
};

var setupEmpty={//empty
	nodes: [
		],
	edges: [
		],

	//material properties - AISI 1095 Carbon Steel (Spring Steel)
	ndofs   : 3*6,

	animation :  {
	
		showDisplacement : true,
		exageration : 2000,
		speed:3.0
		
	},
	viz :  {
	
		
		minStress:-500,
		maxStress: 500,
		colorMaps:[coolwarm,YlGnBu, winter ,jet],
		colorMap:0,
		
	},
	solve: solveFea,
	bar:false
	
};

/////////////////////drawing utils//////////////////////

function addNode(position,restrained,force){
	var bar=setup.bar;
	var numNode=setup.nodes.length;
	setup.nodes.push({
		id: 'n'+numNode, 
		parent: '11',
		degrees_of_freedom:[numNode*3,numNode*3+1,numNode*3+2] , 
		restrained_degrees_of_freedom:[restrained,restrained,restrained],
		position: toPos(position),
		force:toPos(force),
		displacement: { x: 0, y: 0,z:0 },
        angle: { x: 0, y: 0,z:0 }
    });
    
	setup.nodes[numNode].id='n'+numNode;
	setup.nodes[numNode].position=toPos(position);
	setup.nodes[numNode].force=toPos(force);
	setup.nodes[numNode].degrees_of_freedom=[numNode*3,numNode*3+1,numNode*3+2];
	setup.nodes[numNode].restrained_degrees_of_freedom=[restrained,restrained,restrained];
	setup.ndofs = 3 * setup.nodes.length;
	if(!bar){
		setup.nodes[numNode].degrees_of_freedom=[numNode*6,numNode*6+1,numNode*6+2,numNode*6+3,numNode*6+4,numNode*6+5];
		if(restrained){
			restrained=[true,true,true,true,true,true];
		}else{
			restrained=[false,false,false,false,false,false];
		}
		setup.nodes[numNode].restrained_degrees_of_freedom=restrained;
		setup.ndofs = 6 * setup.nodes.length;
	}
}

function addEdge(source,target,area,density,stiffness){
    if (edgeNeeded(source,target)){
        var numEdge=setup.edges.length;

        setup.edges.push({ id: 'e'+numEdge, source: source, target: target ,area:area,density:density,stiffness:stiffness,stress:0 });

        // setup.edges[numEdge].id='e'+numEdge;
        // setup.edges[numEdge].source=source;
        // setup.edges[numEdge].target=target;
        // setup.edges[numEdge].area=area;
        // setup.edges[numEdge].density=density;
        // setup.edges[numEdge].stiffness=stiffness;

    }
	
}

function checkandAdd(pos){
    var restrained=false;
    var force= new THREE.Vector3(0,0,0);
    var node=nodeAt(setup,pos);
    if(typeof node === 'undefined'){ //doesn't exist
        addNode(toThreeVec(pos),restrained, force);
        return parseInt(setup.nodes[setup.nodes.length-1].id.substring(1));
        
    }else{

        // setup.nodes.find(v => v.name === node.name).enabled = false;
        // if(restrained){
        //     restrain(node.id)
        // }
        // addForce(node.id,force);
        return parseInt(node.id.substring(1));//return name
    }
    
}

function linkNodes(nodesIndices){ //create square/circle 
    for(var i=0;i<nodesIndices.length-1;i++){
        addEdge(nodesIndices[i], nodesIndices[i+1], 1.0, 0.284 , 30.0e6);

    }
    addEdge(nodesIndices[nodesIndices.length-1], nodesIndices[0], 1.0, 0.284 , 30.0e6);
}

function restrain(name){
    var restrained;
    if(!setup.bar){
        restrained=[true,true,true,true,true,true];
    }else{
        restrained=[true,true,true];
    }
    setup.nodes.find(v => v.id === name).restrained_degrees_of_freedom=restrained;
    
}

function addForce(name,force){
    var node=setup.nodes.find(v => v.id === name);
    node.force.x += force.x;
    node.force.y += force.y;
    node.force.z += force.z;
}

function restrainBelow(y){
    for(var i=0;i<setup.nodes.length;i++){
        if(setup.nodes[i].position.y<=y){
            if(setup.bar){
                setup.nodes[i].restrained_degrees_of_freedom=[true,true,true];
            }else{
                setup.nodes[i].restrained_degrees_of_freedom=[true,true,true,true,true,true];
            }
        }
    }
}

function addForceAbove(y,force){
    for(var i=0;i<setup.nodes.length;i++){
        if(setup.nodes[i].position.y>=y){
            setup.nodes[i].force.x += force.x;
            setup.nodes[i].force.y += force.y;
            setup.nodes[i].force.z += force.z;
        }
    }
}

////////////